/*
 * Decompiled with CFR 0.152.
 */
package team.creative.solonion.common.item.foodcontainer;

import java.util.ArrayList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import team.creative.solonion.common.item.SOLOnionItems;
import team.creative.solonion.common.item.foodcontainer.FoodContainerItem;
import team.creative.solonion.common.item.foodcontainer.FoodSlot;

public class FoodContainer
extends AbstractContainerMenu {
    public static final int PLAYERSIZE = 36;
    public ItemStack containerItem;
    public int nslots;
    private Inventory playerInventory;

    public FoodContainer(int id, Inventory playerInventory, Player player) {
        super(SOLOnionItems.FOOD_CONTAINER.get(), id);
        if (player.getMainHandItem().getItem() instanceof FoodContainerItem) {
            this.containerItem = player.getMainHandItem();
        } else if (player.getOffhandItem().getItem() instanceof FoodContainerItem) {
            this.containerItem = player.getOffhandItem();
        } else {
            for (ItemStack stack : playerInventory.items) {
                if (!(stack.getItem() instanceof FoodContainerItem)) continue;
                this.containerItem = stack;
                break;
            }
        }
        this.playerInventory = playerInventory;
        final IItemHandler itemHandler = (IItemHandler)this.containerItem.getCapability(Capabilities.ItemHandler.ITEM);
        if (itemHandler != null) {
            this.nslots = itemHandler.getSlots();
            int slotsPerRow = itemHandler.getSlots();
            if (itemHandler.getSlots() > 9) {
                slotsPerRow = itemHandler.getSlots() / 2;
            }
            int xStart = (178 - slotsPerRow * 18) / 2;
            int yStart = 35;
            if (itemHandler.getSlots() > 9) {
                yStart = 29;
            }
            for (int j = 0; j < itemHandler.getSlots(); ++j) {
                int row = j / slotsPerRow;
                int col = j % slotsPerRow;
                int xPos = xStart + col * 18;
                int yPos = yStart + row * 18;
                this.addSlot((Slot)new FoodSlot(itemHandler, j, xPos, yPos));
            }
        }
        this.addSlotListener(new ContainerListener(){

            public void slotChanged(AbstractContainerMenu menu, int slot, ItemStack stack) {
                if (slot < itemHandler.getSlots()) {
                    ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(itemHandler.getSlots());
                    for (int i = 0; i < itemHandler.getSlots(); ++i) {
                        stacks.add(itemHandler.getStackInSlot(i));
                    }
                    FoodContainer.this.containerItem.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(stacks));
                }
            }

            public void dataChanged(AbstractContainerMenu p_150524_, int p_150525_, int p_150526_) {
            }
        });
        this.layoutPlayerInventorySlots(8, 84);
    }

    public void clicked(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        ItemStack clickedStack;
        if (slotId >= 0 && slotId < this.slots.size() && (clickedStack = ((Slot)this.slots.get(slotId)).getItem()).getItem() instanceof FoodContainerItem) {
            return;
        }
        super.clicked(slotId, dragType, clickTypeIn, player);
    }

    public ItemStack quickMoveStack(Player player, int slotId) {
        Slot clickedSlot = (Slot)this.slots.get(slotId);
        if (clickedSlot == null || slotId < 0 || !clickedSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack clickedStack = clickedSlot.getItem();
        if (!FoodSlot.canHold(clickedStack)) {
            return ItemStack.EMPTY;
        }
        ItemStack unchangedCopy = clickedStack.copy();
        if (slotId < this.nslots ? !this.moveItemStackTo(clickedStack, this.nslots, this.nslots + 36, false) : !this.moveItemStackTo(clickedStack, 0, this.nslots, false)) {
            return ItemStack.EMPTY;
        }
        if (clickedStack.isEmpty()) {
            clickedSlot.set(ItemStack.EMPTY);
        } else {
            clickedSlot.setChanged();
        }
        if (clickedStack.getCount() == unchangedCopy.getCount()) {
            return ItemStack.EMPTY;
        }
        clickedSlot.onTake(player, clickedStack);
        return clickedStack;
    }

    private int addSlotRange(Inventory handler, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.addSlot(new Slot((Container)handler, index, x, y));
            x += dx;
            ++index;
        }
        return index;
    }

    private int addSlotBox(Inventory handler, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(handler, index, x, y, horAmount, dx);
            y += dy;
        }
        return index;
    }

    protected void layoutPlayerInventorySlots(int leftCol, int topRow) {
        this.addSlotBox(this.playerInventory, 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange(this.playerInventory, 0, leftCol, topRow += 58, 9, 18);
    }

    public boolean stillValid(Player player) {
        return true;
    }
}

